/************************************************************************************
* This is the header file for the RF4CE profile with id 01 - named ZRC
*
* (c) Copyright 2008, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
************************************************************************************/

#ifndef _ZRC_COMMANDS_H_
#define _ZRC_COMMANDS_H_

#include "EmbeddedTypes.h"
#include "NwkInterface.h"

/******************************************************************************
*******************************************************************************
* Public Macros
*******************************************************************************
******************************************************************************/
/* List of ZRC command codes */
#define gZRC_CmdCode_Reserved_c                      0x00      

/* Sending the pressed command code will not start repeating the command.
   Use gZRC_CmdCode_UserCtrlPressedAndRepeat_c to repeat the command at the repeat interval */
#define gZRC_CmdCode_UserCtrlPressed_c               0x01       
/* The repeated command can not be send by the application. 
   The ZRC Profile repeats the command only if gZRC_CmdCode_UserCtrlPressedAndRepeat_c is used.*/
#define gZRC_CmdCode_UserCtrlRepeated_c              0x02 
/* The released command can be send by the Application
   if it follows a pressed or repeated command. */     
#define gZRC_CmdCode_UserCtrlReleased_c              0x03      
#define gZRC_CmdCode_DiscoveryRequest_c              0x04      
#define gZRC_CmdCode_DiscoveryResponse_c             0x05 

/* Sends user control pressed command frame and starts repeating 
   the command (sending user control repeated command frames at the repeat interval attribute ) */    
#define gZRC_CmdCode_UserCtrlPressedAndRepeat_c      0x81     
 
   

/* List of user control pressed RC command codes */
#define gZRC_CmdRC_Select_c                   0x00
#define gZRC_CmdRC_Up_c                       0x01
#define gZRC_CmdRC_Down_c                     0x02
#define gZRC_CmdRC_Left_c                     0x03
#define gZRC_CmdRC_Right_c                    0x04
#define gZRC_CmdRC_RightUp_c                  0x05
#define gZRC_CmdRC_RightDown_c                0x06
#define gZRC_CmdRC_LeftUp_c                   0x07
#define gZRC_CmdRC_LeftDown_c                 0x08
#define gZRC_CmdRC_RootMenu_c                 0x09
#define gZRC_CmdRC_SetupMenu_c                0x0A
#define gZRC_CmdRC_ContentsMenu_c             0x0B
#define gZRC_CmdRC_FavoriteMenu_c             0x0C
#define gZRC_CmdRC_Exit_c                     0x0D

#define gZRC_CmdRC_MediaTopMenu_c             0x10
#define gZRC_CmdRC_MediaContextSensitive_c    0x11

#define gZRC_CmdRC_NumpadEntryMode_c          0x1D
#define gZRC_CmdRC_Numpad11_c                 0x1E
#define gZRC_CmdRC_Numpad12_c                 0x1F             
#define gZRC_CmdRC_Numpad0_or_10_c            0x20
#define gZRC_CmdRC_Numpad1_c                  0x21
#define gZRC_CmdRC_Numpad2_c                  0x22
#define gZRC_CmdRC_Numpad3_c                  0x23
#define gZRC_CmdRC_Numpad4_c                  0x24
#define gZRC_CmdRC_Numpad5_c                  0x25
#define gZRC_CmdRC_Numpad6_c                  0x26
#define gZRC_CmdRC_Numpad7_c                  0x27
#define gZRC_CmdRC_Numpad8_c                  0x28
#define gZRC_CmdRC_Numpad9_c                  0x29
#define gZRC_CmdRC_Dot_c                      0x2A
#define gZRC_CmdRC_Enter_c                    0x2B
#define gZRC_CmdRC_Clear_c                    0x2C

#define gZRC_CmdRC_NextFavorite_c             0x2F
#define gZRC_CmdRC_ChannelUp_c                0x30
#define gZRC_CmdRC_ChannelDown_c              0x31
#define gZRC_CmdRC_PreviousChannel_c          0x32
#define gZRC_CmdRC_SoundSelect_c              0x33
#define gZRC_CmdRC_InputSelect_c              0x34
#define gZRC_CmdRC_DisplayInfo_c              0x35
#define gZRC_CmdRC_Help_c                     0x36
#define gZRC_CmdRC_PageUp_c                   0x37
#define gZRC_CmdRC_PageDown_c                 0x38

#define gZRC_CmdRC_Power_c                    0x40
#define gZRC_CmdRC_VolumeUp_c                 0x41
#define gZRC_CmdRC_VolumeDown_c               0x42
#define gZRC_CmdRC_Mute_c                     0x43
#define gZRC_CmdRC_Play_c                     0x44
#define gZRC_CmdRC_Stop_c                     0x45
#define gZRC_CmdRC_Pause_c                    0x46
#define gZRC_CmdRC_Record_c                   0x47
#define gZRC_CmdRC_Rewind_c                   0x48
#define gZRC_CmdRC_FastForward_c              0x49
#define gZRC_CmdRC_Eject_c                    0x4A
#define gZRC_CmdRC_Forward_c                  0x4B
#define gZRC_CmdRC_Backward_c                 0x4C
#define gZRC_CmdRC_StopRecord_c               0x4D
#define gZRC_CmdRC_PauseRecord_c              0x4E

#define gZRC_CmdRC_Angle_c                    0x50
#define gZRC_CmdRC_SubPicture_c               0x51
#define gZRC_CmdRC_VideoOnDemand_c            0x52
#define gZRC_CmdRC_EPG_c                      0x53
#define gZRC_CmdRC_TimerProgramming_c         0x54
#define gZRC_CmdRC_InitialConfig_c            0x55
#define gZRC_CmdRC_SelectBroadcastType_c      0x56
#define gZRC_CmdRC_SelectSoundPresentation_c  0x57

#define gZRC_CmdRC_PlayFunction_c             0x60
#define gZRC_CmdRC_PausePlayFunction_c        0x61
#define gZRC_CmdRC_RecordFunction_c           0x62
#define gZRC_CmdRC_PauseRecordFunction_c      0x63
#define gZRC_CmdRC_StopFunction_c             0x64
#define gZRC_CmdRC_MuteFunction_c             0x65
#define gZRC_CmdRC_RestoreVolumeFunction_c    0x66
#define gZRC_CmdRC_TuneFunction_c             0x67
#define gZRC_CmdRC_SelectMediaFunction_c      0x68
#define gZRC_CmdRC_SelectAVInputFunction_c    0x69
#define gZRC_CmdRC_SelectAudioInputFunction_c 0x6A
#define gZRC_CmdRC_PowerToggleFunction_c      0x6B
#define gZRC_CmdRC_PowerOffFunction_c         0x6C
#define gZRC_CmdRC_PowerOnFunction_c          0x6D

#define gZRC_CmdRC_F1_c                       0x71
#define gZRC_CmdRC_F2_c                       0x72
#define gZRC_CmdRC_F3_c                       0x73
#define gZRC_CmdRC_F4_c                       0x74
#define gZRC_CmdRC_F5_c                       0x75
#define gZRC_CmdRC_Data_c                     0x76

/******************************************************************************/
/* List of supported commands */
#define gZRC_CmdRC_Select_Supported_c                   TRUE
#define gZRC_CmdRC_Up_Supported_c                       TRUE
#define gZRC_CmdRC_Down_Supported_c                     TRUE
#define gZRC_CmdRC_Left_Supported_c                     TRUE
#define gZRC_CmdRC_Right_Supported_c                    TRUE
#define gZRC_CmdRC_RightUp_Supported_c                  FALSE
#define gZRC_CmdRC_RightDown_Supported_c                FALSE
#define gZRC_CmdRC_LeftUp_Supported_c                   FALSE
#define gZRC_CmdRC_LeftDown_Supported_c                 FALSE
#define gZRC_CmdRC_RootMenu_Supported_c                 TRUE
#define gZRC_CmdRC_SetupMenu_Supported_c                FALSE
#define gZRC_CmdRC_ContentsMenu_Supported_c             FALSE
#define gZRC_CmdRC_FavoriteMenu_Supported_c             FALSE
#define gZRC_CmdRC_Exit_Supported_c                     TRUE

#define gZRC_CmdRC_MediaTopMenu_Supported_c             FALSE
#define gZRC_CmdRC_MediaContextSensitive_Supported_c    FALSE

#define gZRC_CmdRC_NumpadEntryMode_Supported_c          FALSE
#define gZRC_CmdRC_Numpad11_Supported_c                 FALSE
#define gZRC_CmdRC_Numpad12_Supported_c                 FALSE             
#define gZRC_CmdRC_Numpad0_or_10_Supported_c            FALSE
#define gZRC_CmdRC_Numpad1_Supported_c                  FALSE
#define gZRC_CmdRC_Numpad2_Supported_c                  FALSE
#define gZRC_CmdRC_Numpad3_Supported_c                  FALSE
#define gZRC_CmdRC_Numpad4_Supported_c                  FALSE
#define gZRC_CmdRC_Numpad5_Supported_c                  FALSE
#define gZRC_CmdRC_Numpad6_Supported_c                  FALSE
#define gZRC_CmdRC_Numpad7_Supported_c                  FALSE
#define gZRC_CmdRC_Numpad8_Supported_c                  FALSE
#define gZRC_CmdRC_Numpad9_Supported_c                  FALSE
#define gZRC_CmdRC_Dot_Supported_c                      FALSE
#define gZRC_CmdRC_Enter_Supported_c                    FALSE
#define gZRC_CmdRC_Clear_Supported_c                    FALSE

#define gZRC_CmdRC_NextFavorite_Supported_c             FALSE
#define gZRC_CmdRC_ChannelUp_Supported_c                TRUE
#define gZRC_CmdRC_ChannelDown_Supported_c              TRUE
#define gZRC_CmdRC_PreviousChannel_Supported_c          FALSE
#define gZRC_CmdRC_SoundSelect_Supported_c              FALSE
#define gZRC_CmdRC_InputSelect_Supported_c              FALSE
#define gZRC_CmdRC_DisplayInfo_Supported_c              FALSE
#define gZRC_CmdRC_Help_Supported_c                     FALSE
#define gZRC_CmdRC_PageUp_Supported_c                   FALSE
#define gZRC_CmdRC_PageDown_Supported_c                 FALSE

#define gZRC_CmdRC_Power_Supported_c                    FALSE
#define gZRC_CmdRC_VolumeUp_Supported_c                 TRUE
#define gZRC_CmdRC_VolumeDown_Supported_c               TRUE
#define gZRC_CmdRC_Mute_Supported_c                     FALSE
#define gZRC_CmdRC_Play_Supported_c                     FALSE
#define gZRC_CmdRC_Stop_Supported_c                     FALSE
#define gZRC_CmdRC_Pause_Supported_c                    FALSE
#define gZRC_CmdRC_Record_Supported_c                   FALSE
#define gZRC_CmdRC_Rewind_Supported_c                   FALSE
#define gZRC_CmdRC_FastForward_Supported_c              FALSE
#define gZRC_CmdRC_Eject_Supported_c                    FALSE
#define gZRC_CmdRC_Forward_Supported_c                  FALSE
#define gZRC_CmdRC_Backward_Supported_c                 FALSE
#define gZRC_CmdRC_StopRecord_Supported_c               FALSE
#define gZRC_CmdRC_PauseRecord_Supported_c              FALSE

#define gZRC_CmdRC_Angle_Supported_c                    FALSE
#define gZRC_CmdRC_SubPicture_Supported_c               FALSE
#define gZRC_CmdRC_VideoOnDemand_Supported_c            FALSE
#define gZRC_CmdRC_EPG_Supported_c                      FALSE
#define gZRC_CmdRC_TimerProgramming_Supported_c         FALSE
#define gZRC_CmdRC_InitialConfig_Supported_c            FALSE
#define gZRC_CmdRC_SelectBroadcastType_Supported_c      FALSE
#define gZRC_CmdRC_SelectSoundPresentation_Supported_c  FALSE

#define gZRC_CmdRC_PlayFunction_Supported_c             FALSE
#define gZRC_CmdRC_PausePlayFunction_Supported_c        FALSE
#define gZRC_CmdRC_RecordFunction_Supported_c           FALSE
#define gZRC_CmdRC_PauseRecordFunction_Supported_c      FALSE
#define gZRC_CmdRC_StopFunction_Supported_c             FALSE
#define gZRC_CmdRC_MuteFunction_Supported_c             FALSE
#define gZRC_CmdRC_RestoreVolumeFunction_Supported_c    FALSE
#define gZRC_CmdRC_TuneFunction_Supported_c             FALSE
#define gZRC_CmdRC_SelectMediaFunction_Supported_c      FALSE
#define gZRC_CmdRC_SelectAVInputFunction_Supported_c    FALSE
#define gZRC_CmdRC_SelectAudioInputFunction_Supported_c FALSE
#define gZRC_CmdRC_PowerToggleFunction_Supported_c      TRUE
#define gZRC_CmdRC_PowerOffFunction_Supported_c         TRUE
#define gZRC_CmdRC_PowerOnFunction_Supported_c          TRUE

#define gZRC_CmdRC_F1_Supported_c                       FALSE
#define gZRC_CmdRC_F2_Supported_c                       FALSE
#define gZRC_CmdRC_F3_Supported_c                       FALSE
#define gZRC_CmdRC_F4_Supported_c                       FALSE
#define gZRC_CmdRC_F5_Supported_c                       FALSE
#define gZRC_CmdRC_Data_Supported_c                     FALSE

/******************************************************************************/
/* List of supported commands */
#define gZRC_CmdSupportedBitMap_c  { \
/* Byte 0 */ \
((gZRC_CmdRC_Select_Supported_c     * (0x01 << 0x00)) | \
 (gZRC_CmdRC_Up_Supported_c         * (0x01 << 0x01)) | \
 (gZRC_CmdRC_Down_Supported_c       * (0x01 << 0x02)) | \
 (gZRC_CmdRC_Left_Supported_c       * (0x01 << 0x03)) | \
 (gZRC_CmdRC_Right_Supported_c      * (0x01 << 0x04)) | \
 (gZRC_CmdRC_RightUp_Supported_c    * (0x01 << 0x05)) | \
 (gZRC_CmdRC_RightDown_Supported_c  * (0x01 << 0x06)) | \
 (gZRC_CmdRC_LeftUp_Supported_c     * (0x01 << 0x07))), \
/* Byte 1 */  \
((gZRC_CmdRC_LeftDown_Supported_c       * (0x01 << 0x00)) | \
 (gZRC_CmdRC_RootMenu_Supported_c       * (0x01 << 0x01)) | \
 (gZRC_CmdRC_SetupMenu_Supported_c      * (0x01 << 0x02)) | \
 (gZRC_CmdRC_ContentsMenu_Supported_c   * (0x01 << 0x03)) | \
 (gZRC_CmdRC_FavoriteMenu_Supported_c   * (0x01 << 0x04)) | \
 (gZRC_CmdRC_Exit_Supported_c           * (0x01 << 0x05))), \
/* Byte 2 */  \
((gZRC_CmdRC_MediaTopMenu_Supported_c            * (0x01 << 0x00)) | \
 (gZRC_CmdRC_MediaContextSensitive_Supported_c   * (0x01 << 0x01))), \
/* Byte 3 */  \
 ((gZRC_CmdRC_NumpadEntryMode_Supported_c   * (0x01 << 0x05)) | \
  (gZRC_CmdRC_Numpad11_Supported_c          * (0x01 << 0x06)) | \
  (gZRC_CmdRC_Numpad12_Supported_c          * (0x01 << 0x07))), \
/* Byte 4 */  \
((gZRC_CmdRC_Numpad0_or_10_Supported_c   * (0x01 << 0x00)) | \
 (gZRC_CmdRC_Numpad1_Supported_c         * (0x01 << 0x01)) | \
 (gZRC_CmdRC_Numpad2_Supported_c         * (0x01 << 0x02)) | \
 (gZRC_CmdRC_Numpad3_Supported_c         * (0x01 << 0x03)) | \
 (gZRC_CmdRC_Numpad4_Supported_c         * (0x01 << 0x04)) | \
 (gZRC_CmdRC_Numpad5_Supported_c         * (0x01 << 0x05)) | \
 (gZRC_CmdRC_Numpad6_Supported_c         * (0x01 << 0x06)) | \
 (gZRC_CmdRC_Numpad7_Supported_c         * (0x01 << 0x07))), \
/* Byte 5 */  \
((gZRC_CmdRC_Numpad8_Supported_c      * (0x01 << 0x00)) | \
 (gZRC_CmdRC_Numpad9_Supported_c      * (0x01 << 0x01)) | \
 (gZRC_CmdRC_Dot_Supported_c          * (0x01 << 0x02)) | \
 (gZRC_CmdRC_Enter_Supported_c        * (0x01 << 0x03)) | \
 (gZRC_CmdRC_Clear_Supported_c        * (0x01 << 0x04)) | \
 (gZRC_CmdRC_NextFavorite_Supported_c * (0x01 << 0x07))), \
/* Byte 6 */  \
((gZRC_CmdRC_ChannelUp_Supported_c         * (0x01 << 0x00)) | \
 (gZRC_CmdRC_ChannelDown_Supported_c       * (0x01 << 0x01)) | \
 (gZRC_CmdRC_PreviousChannel_Supported_c   * (0x01 << 0x02)) | \
 (gZRC_CmdRC_SoundSelect_Supported_c       * (0x01 << 0x03)) | \
 (gZRC_CmdRC_InputSelect_Supported_c       * (0x01 << 0x04)) | \
 (gZRC_CmdRC_DisplayInfo_Supported_c       * (0x01 << 0x05)) | \
 (gZRC_CmdRC_Help_Supported_c              * (0x01 << 0x06)) | \
 (gZRC_CmdRC_PageUp_Supported_c            * (0x01 << 0x07))), \
/* Byte 7 */   \
((gZRC_CmdRC_PageDown_Supported_c     * (0x01 << 0x00)) ), \
/* Byte 8 */  \
((gZRC_CmdRC_Power_Supported_c         * (0x01 << 0x00)) | \
 (gZRC_CmdRC_VolumeUp_Supported_c      * (0x01 << 0x01)) | \
 (gZRC_CmdRC_VolumeDown_Supported_c    * (0x01 << 0x02)) | \
 (gZRC_CmdRC_Mute_Supported_c          * (0x01 << 0x03)) | \
 (gZRC_CmdRC_Play_Supported_c          * (0x01 << 0x04)) | \
 (gZRC_CmdRC_Stop_Supported_c          * (0x01 << 0x05)) | \
 (gZRC_CmdRC_Pause_Supported_c         * (0x01 << 0x06)) | \
 (gZRC_CmdRC_Record_Supported_c        * (0x01 << 0x07))), \
/* Byte 9 */  \
((gZRC_CmdRC_Rewind_Supported_c        * (0x01 << 0x00)) | \
 (gZRC_CmdRC_FastForward_Supported_c   * (0x01 << 0x01)) | \
 (gZRC_CmdRC_Eject_Supported_c         * (0x01 << 0x02)) | \
 (gZRC_CmdRC_Forward_Supported_c       * (0x01 << 0x03)) | \
 (gZRC_CmdRC_Backward_Supported_c      * (0x01 << 0x04)) | \
 (gZRC_CmdRC_StopRecord_Supported_c    * (0x01 << 0x05)) | \
 (gZRC_CmdRC_PauseRecord_Supported_c   * (0x01 << 0x06))), \
 /* Byte 10 */  \
((gZRC_CmdRC_Angle_Supported_c                   * (0x01 << 0x00)) | \
 (gZRC_CmdRC_SubPicture_Supported_c              * (0x01 << 0x01)) | \
 (gZRC_CmdRC_VideoOnDemand_Supported_c           * (0x01 << 0x02)) | \
 (gZRC_CmdRC_EPG_Supported_c                     * (0x01 << 0x03)) | \
 (gZRC_CmdRC_TimerProgramming_Supported_c        * (0x01 << 0x04)) | \
 (gZRC_CmdRC_InitialConfig_Supported_c           * (0x01 << 0x05)) | \
 (gZRC_CmdRC_SelectBroadcastType_Supported_c     * (0x01 << 0x06)) | \
 (gZRC_CmdRC_SelectSoundPresentation_Supported_c * (0x01 << 0x07))), \
 /* Byte 11 */  \
(0x00), \
/* Byte 12 */   \
((gZRC_CmdRC_PlayFunction_Supported_c           * (0x01 << 0x00)) | \
 (gZRC_CmdRC_PausePlayFunction_Supported_c      * (0x01 << 0x01)) | \
 (gZRC_CmdRC_RecordFunction_Supported_c         * (0x01 << 0x02)) | \
 (gZRC_CmdRC_PauseRecordFunction_Supported_c    * (0x01 << 0x03)) | \
 (gZRC_CmdRC_StopFunction_Supported_c           * (0x01 << 0x04)) | \
 (gZRC_CmdRC_MuteFunction_Supported_c           * (0x01 << 0x05)) | \
 (gZRC_CmdRC_RestoreVolumeFunction_Supported_c  * (0x01 << 0x06)) | \
 (gZRC_CmdRC_TuneFunction_Supported_c           * (0x01 << 0x07))), \
 /* Byte 13 */  \
((gZRC_CmdRC_SelectMediaFunction_Supported_c       * (0x01 << 0x00)) | \
 (gZRC_CmdRC_SelectAVInputFunction_Supported_c     * (0x01 << 0x01)) | \
 (gZRC_CmdRC_SelectAudioInputFunction_Supported_c  * (0x01 << 0x02)) | \
 (gZRC_CmdRC_PowerToggleFunction_Supported_c       * (0x01 << 0x03)) | \
 (gZRC_CmdRC_PowerOffFunction_Supported_c          * (0x01 << 0x04)) | \
 (gZRC_CmdRC_PowerOnFunction_Supported_c           * (0x01 << 0x05))), \
 /* Byte 14 */  \
((gZRC_CmdRC_F1_Supported_c         * (0x01 << 0x01)) | \
 (gZRC_CmdRC_F2_Supported_c         * (0x01 << 0x02)) | \
 (gZRC_CmdRC_F3_Supported_c         * (0x01 << 0x03)) | \
 (gZRC_CmdRC_F4_Supported_c         * (0x01 << 0x04)) | \
 (gZRC_CmdRC_F5_Supported_c         * (0x01 << 0x05)) | \
 (gZRC_CmdRC_Data_Supported_c       * (0x01 << 0x06))), \
 /* Rest of bytes */ \
 0x00, 0x00, 0x00, 0x00, 0x00,0x00, 0x00, 0x00,\
 0x00, 0x00, 0x00,0x00, 0x00, 0x00, 0x00, 0x00, 0x00 \
 }                                                      

/******************************************************************************
*******************************************************************************
* Public type definitions
*******************************************************************************
******************************************************************************/


/******************************************************************************
*******************************************************************************
* Public Memory Declarations
*******************************************************************************
******************************************************************************/


/******************************************************************************
*******************************************************************************
* Public Prototypes
*******************************************************************************
******************************************************************************/



#endif /* _ZRC_COMMANDS_H_ */
